<?php

  namespace App\Http\Controllers;

  use App\Models\StaticContent;
  use Illuminate\Http\Request;
  use Illuminate\Http\JsonResponse;
  use Illuminate\Support\Facades\Validator;

  class StaticContentController extends Controller
  {
      public function index(): JsonResponse
      {
          $contents = StaticContent::all();
          return response()->json([
              'status' => 'success',
              'data' => $contents,
          ], 200);
      }

      public function show($id): JsonResponse
      {
          $content = StaticContent::findOrFail($id);
          return response()->json([
              'status' => 'success',
              'data' => $content,
          ], 200);
      }

      public function store(Request $request): JsonResponse
      {
          $validator = Validator::make($request->all(), [
              'Page_name' => 'required|string|max:255',
              'Content' => 'required',
              'Updated_by' => 'required|exists:users,User_id',
          ]);

          if ($validator->fails()) {
              return response()->json([
                  'status' => 'error',
                  'errors' => $validator->errors(),
              ], 422);
          }

          $content = StaticContent::create($request->only(['Page_name', 'Content', 'Updated_by']));

          return response()->json([
              'status' => 'success',
              'data' => $content,
          ], 201);
      }

     public function update(Request $request, $id): JsonResponse
    {
        $content = StaticContent::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'Page_name' => 'sometimes|string|max:255',
            'Content' => 'sometimes',
            'Updated_by' => 'nullable|exists:users,User_id', // Updated rule to allow null
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors(),
            ], 422);
        }

        $content->update($request->only(['Page_name', 'Content', 'Updated_by']));

        return response()->json([
            'status' => 'success',
            'data' => $content,
        ], 200);
    }

      public function destroy($id): JsonResponse
      {
          $content = StaticContent::findOrFail($id);
          $content->delete();

          return response()->json([
              'status' => 'success',
              'message' => 'Content deleted successfully',
          ], 200);
      }
  }
